<?php
/**
 * Veidotājs: Roberts Blite
 * Mērķis: Šis PHP skripts pārvalda darba stundu operācijas, nodrošinot savienojumu ar datubāzi.
 * Izveides datums: 2025-02-06
 */

// Datubāzes pieslēguma iestatījumi
$servername = "database-1.cd0m46mqkm83.eu-north-1.rds.amazonaws.com";
$username = "admin";
$password = "HyperX3146!";
$dbname = "rb_kvalif_410";

// Izveido savienojumu ar datubāzi
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojumu
if ($conn->connect_error) {
    die(json_encode(["error" => "Neizdevās izveidot savienojumu ar datubāzi: " . $conn->connect_error]));
}

session_start();
header('Content-Type: application/json');

// Sesijas pārbaude
$user_id = $_SESSION['user_id'] ?? null;
$action = $_POST['action'] ?? $_GET['action'] ?? null;

// Pārbauda, vai lietotājs ir autentificēts
if (!$user_id) {
    echo json_encode(["error" => "Piekļuve liegta. Nepieciešama autentifikācija."]);
    exit;
}

// Darba stundu iegūšana
if ($action === "fetch-work-hours") {
    $sql = "SELECT date, clock_in_time, 
                   IF(clock_out_time IS NULL, 'Nav pieejams', clock_out_time) AS clock_out_time,
                   IF(clock_out_time IS NULL, 'Procesā', FORMAT(total_work_hours, 2)) AS total_work_hours
            FROM rb_kvalif_workhours_410 
            WHERE user_id = ? ORDER BY date DESC";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $work_hours = $result->fetch_all(MYSQLI_ASSOC);
    echo json_encode(["data" => $work_hours]);
    exit;
}

// Darba sākuma laika reģistrācija
elseif ($action === "clock-in") {
    $date = date('Y-m-d');
    $time = date('H:i:s');

    $sql = "INSERT INTO rb_kvalif_workhours_410 (user_id, date, clock_in_time) VALUES (?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("iss", $user_id, $date, $time);
    if ($stmt->execute()) {
        echo json_encode(["success" => "Darba sākums veiksmīgi reģistrēts plkst. $time."]);
    } else {
        echo json_encode(["error" => "Neizdevās reģistrēt darba sākumu: " . $stmt->error]);
    }
    exit;
}

// Darba beigu laika reģistrācija
elseif ($action === "clock-out") {
    $date = date('Y-m-d');
    $time = date('H:i:s');

    $sql = "UPDATE rb_kvalif_workhours_410 
            SET clock_out_time = ?, 
                total_work_hours = TIMESTAMPDIFF(SECOND, CONCAT(date, ' ', clock_in_time), CONCAT(date, ' ', ?)) / 3600
            WHERE user_id = ? AND date = ? AND clock_out_time IS NULL";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssis", $time, $time, $user_id, $date);
    if ($stmt->execute()) {
        echo json_encode(["success" => "Darba beigas veiksmīgi reģistrētas plkst. $time."]);
    } else {
        echo json_encode(["error" => "Neizdevās reģistrēt darba beigas: " . $stmt->error]);
    }
    exit;
}

// Ja darbība nav norādīta vai ir nederīga
echo json_encode(["error" => "Nepareiza darbība."]);
$conn->close();
?>
